<!DOCTYPE html>
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <title>
        @if(View::hasSection('title'))
            @yield('title') |  SMI Mobile ESS
        @else
            SMI Mobile ESS
        @endif
    </title>
    <meta name="description" content="@yield('meta_description', 'ESS')">
    <meta name="author" content="@yield('meta_author', 'ESS')">

    @yield('meta')

    <style type="text/css">
        body{
            font: 12pt Verdana;
            line-height: 1.3;
            background: #fff !important;
            color: #000;
        }
        h1, h2, h3, h4, h5, h6 { page-break-after:avoid;
            page-break-inside:avoid }
        img, td { page-break-inside:avoid;}
        ul, ol, dl  { page-break-before:avoid }
        table, tr, td, th, tbody, thead, tfoot {
            page-break-inside: avoid !important;
        }
        thead {
            display: table-header-group;
        }
        tfoot {
            display: table-row-group;
        }
        table{
            border-collapse: collapse;
            border-spacing: 0;
            empty-cells: show;
            width: 100%;
        }
        table thead{
            color: #000;
            text-align: center;
            vertical-align: top;
            /* border: 1px solid; */
        }
        table th{
            border: 1px solid;
        }
        table tbody{
            border-bottom: 1px solid;
        }
        table td{
            border-left: 1px solid;
            border-right: 1px solid;
            border-bottom: 1px dotted #ccc;
            font-size: 1em;
        }
        table th, td{
            padding: 0.5em 1em;
        }
        .text-right{
            text-align: right;
        }
        table.table-point th,table.table-point tbody,table.table-point td{
            border: 0;
        }
        table.table-point tbody td{
            padding: 0 1em;
        }
        table.table-point thead{
            border-top: 1px solid black;
            border-bottom: 1px solid black;
        }
        table.table-point tbody{
            border-bottom: 1px solid black;
        }
        table.slip-header th,table.slip-header tbody,table.slip-header td{
            border: 0;
        }
        table.slip-header{
            white-space: nowrap;
            margin-bottom: 1.5em;
        }
        table.no-border, 
        table.no-border tr,
        table.no-border thead,
        table.no-border th,
        table.no-border tbody,
        table.no-border td{
            border: 0;
        }
        @media print{
            @page {
                size: landscape;
                margin: 7mm;
            }
        }
        .header{
            width: 100%;
        }
        .title img{
            float: left;
        }

        .header .title{
            text-align: center;
            width: 50em;
            line-height: 2em;
            margin-bottom: 1em;
            margin: auto;
            padding: 10px;
        }
        .smaller{
            font-size: .7em;
            line-height: 2em;
            vertical-align: bottom;
        }
    </style>
    @stack('after-styles')
</head>

<body class="laporan">
    <div class="app-body">
        <main class="main">

            <div class="container-fluid">
                    @yield('content')
            </div><!--container-fluid-->
        </main><!--main-->
{{--
        @include('backend.includes.aside')
--}}
    </div><!--app-body-->

    {{-- @include('backend.includes.footer') --}}

    <!-- Scripts -->
    @stack('before-scripts')
    @stack('after-scripts')
</body>
</html>
