<?php
    $periode_awal = date('Y-m-d', strtotime($header->PeriodeLemburAwal));
    $periode_akhir = date('Y-m-d', strtotime($header->PeriodeLemburAkhir));

    $element_points = [
        'Hari Kerja',
        'Hari Kerja Shift II',
        '&nbsp;',
        'Lembur',
        '1.5&times;',
        '2.0&times;',
        '2.5&times;',
        '3.0&times;',
        '4.0&times;',
        '&nbsp;',
        'Tidak Hadir'
    ];

    $element_pendapatan = [
        'Gaji Pokok',
        'Lembur',
        'UM Lembur',
        'Transport',
        'Shift 1 Puasa',
        'Kompensasi Karawang',
        'Total',
    ];

    $element_potongan = [
        'Jamsostek',
        'BPJS Kesehatan',
        'BPJS Pensiun',
        'PPH ps 21 (K2)',
        'Pinjaman',
        'Pembulatan',
        'Total',
    ];
?>


<?php $__env->startSection('title', '' . $config['title']); ?>

<?php $__env->startSection('content'); ?>
    <table class="slip-header">
        <tbody>
            <tr>
                <td colspan="4">PT SENTRAL MULTI INDOTAMA</td>
                <td width="1">DATE</td>
                <td width="1">: <?php echo e(date('d F Y')); ?></td>
            </tr>
            <tr>
                <td width="1">NAMA</td>
                <td width="1" colspan="3">: <?php echo e($header->EmpCode.'- '. $header->FullName); ?></td>
                <td>TIME</td>
                <td>: <?php echo e(date('H:i:s')); ?></td>
            </tr>
            <tr>
                <td>DIVISI</td>
                <td>: <?php echo e($header->DivName); ?></td>
               
             <td width="1">GAJI </td>
                <td width="1">: <?php echo e(date('F Y', strtotime($header->TahunGaji.'-'.$header->BulanGaji.'-01'))); ?></td>
            </tr>
            <tr>
                <td>REKENING</td>    
            <td >:  <?php echo e($header->AccountNo); ?>  </td>
                <td>PERIODE LEMBUR</td>
                <td>: <?php echo e(date('d-m-Y', strtotime($periode_awal))); ?> sd <?php echo e(date('d-m-Y', strtotime($periode_akhir))); ?></td>
            </tr>

 
        </tbody>
    </table><!-- /.no-border -->
    <table class="table-point">
        <thead>
            <tr>
                <td>Keterangan</td>
                <?php for($awal = strtotime($periode_awal); $awal <= strtotime($periode_akhir); $awal += 86400): ?>
                    <td class="smaller text-right"><?php echo e(date('d', $awal)); ?></td>
                <?php endfor; ?>
                <td class="text-right">Point</td>
            </tr>
        </thead>
        <tbody>
            <?php $__currentLoopData = $absensi; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $num => $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <?php if($num == 0): ?> <?php continue; ?> <?php endif; ?>
                <tr>
                    <?php $__currentLoopData = $row; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $idx => $col): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <td class="smaller <?php if($idx > 0): ?> text-right <?php endif; ?>">
                            <?php echo e($col); ?>

                        </td>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            
            
        </tbody>
    </table>
    <table class="no-border">
        <tbody>
            <tr>
                <td colspan="3" width="50"><strong>PENDAPATAN</strong></td>
                <td>&nbsp;</td>
                <td colspan="3" width="50"><strong>POTONGAN</strong></td>
            </tr>
            <tr>
                <td style="border: 1px solid;"><strong>Keterangan</strong></td>
                <td style="border: 1px solid;"><strong>Tunj./Hari</strong></td>
                <td style="border: 1px solid;" class="text-right"><strong>Jumlah</strong></td>
                <td>&nbsp;</td>
                <td style="border: 1px solid;"><strong>Keterangan</strong></td>
                <td style="border: 1px solid;"><strong>Pot./Hari</strong></td>
                <td style="border: 1px solid;" class="text-right"><strong>Jumlah</strong></td>
            </tr>
            <?php for($i = 0; $i < max(count($pendapatan), count($potongan)); $i++): ?>
                <tr>
                    <?php if(isset($pendapatan[$i])): ?>
                    <?php if( $pendapatan[$i]->Keterangan =='TOTAL'): ?>
                   
                    <td style="border: 1px solid;"><strong><?php echo e($pendapatan[$i]->Keterangan); ?></strong></td>
                    <td style="border: 1px solid;"><strong><?php echo e($pendapatan[$i]->TunjanganPerHari); ?></strong></td>
                    <td style="border: 1px solid;" class="text-right"><strong><?php echo e(number_format($pendapatan[$i]->Jumlah, 0, ',', '.')); ?></strong></td>
                   
               <?php else: ?>
               <td style="border: 1px solid;"><?php echo e($pendapatan[$i]->Keterangan); ?></td>
               <td style="border: 1px solid;"><?php echo e($pendapatan[$i]->TunjanganPerHari); ?></td>
               <td style="border: 1px solid;" class="text-right"><?php echo e(number_format($pendapatan[$i]->Jumlah, 0, ',', '.')); ?></td>
              
               <?php endif; ?>
                    <?php else: ?>
                        <td>&nbsp;</td>
                        <td>&nbsp;</td>
                        <td>&nbsp;</td>
                    <?php endif; ?>
                    <td>&nbsp;</td>
                    <?php if(isset($potongan[$i])): ?>
                    <?php if( $potongan[$i]->Keterangan =='TOTAL'): ?>
                        
                    
                    <td style="border: 1px solid;"><strong><?php echo e($potongan[$i]->Keterangan); ?></strong></td>
                    <td style="border: 1px solid;"><strong><?php echo e($potongan[$i]->TunjanganPerHari); ?></strong></td>
                    <td style="border: 1px solid;" class="text-right"><strong><?php echo e(number_format($potongan[$i]->Jumlah, 0, ',', '.')); ?></strong></td> 
                       
                   <?php else: ?>
                   <td style="border: 1px solid;"><?php echo e($potongan[$i]->Keterangan); ?></td>
                   <td style="border: 1px solid;"><?php echo e($potongan[$i]->TunjanganPerHari); ?></td>
                   <td style="border: 1px solid;" class="text-right"><?php echo e(number_format($potongan[$i]->Jumlah, 0, ',', '.')); ?></td> 
                      
                
                <?php endif; ?>
                   
   <?php else: ?>
                        <td>&nbsp;</td>
                        <td>&nbsp;</td>
                        <td>&nbsp;</td>
                    <?php endif; ?>
                </tr>
            <?php endfor; ?>
            
        </tbody>
    </table>
    <p style="text-align: right">
        PENERIMA (.......................)
    </p>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('laporan', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\SMIMobileESS\resources\views/slip.blade.php ENDPATH**/ ?>